  /**************************************************************************************
 
   Copyright (c) Hilscher GmbH. All Rights Reserved.
 
 **************************************************************************************
 
   Filename:
    $Workfile: ProfibusMPI_RFC1006_Public.h $
   Last Modification:
    $Author: Alexanderw $
    $Modtime: 12.06.08 10:58 $
    $Revision: 1 $
   
   Targets:
    Win32/ANSI   : no
    Win32/Unicode: no (define _UNICODE)
    WinCE        : yes
    rcX          : yes
 
   Description:
     
    ProfibusMPI_ RFC1006
    public
   
   Changes:
 
     Version    Date        Author
        Description
     ----------------------------------------------------------------------------------
        
**************************************************************************************/
/**
 * @file ProfibusMPI_RFC1006_Public.h
 *  ProfibusMPI_ RFC1006 - public definition of task
 *
 * The header contains the public definition of task.
 * It has to be included by another task to get access of task specfic definition.
 * 
 * @note
 * The structures for the services must be packed on 1 byte of boundary.
 * The <code>#pragma</code> instructions are already planned for Microsoft compiler.
 * For gnu's compiler and Realview compiler the macros <code>__PACKED_PRE</code>
 * and <code>__PACKED_PRE</code> have to be added with the structural definition
 * in addition.
 */
#ifndef __PROFIBUSMPI_RFC1006_PUBLIC_H
#define __PROFIBUSMPI_RFC1006_PUBLIC_H


/*************************************************************************************/
/** @name Queue Name
 *
 * Use the queue name to identify the process queue of task 'ProfibusMPI_ RFC1006'.
 * Example for internal identification:<br>
 * @code
 * TLR_RESULT eRslt;
 * TLR_HANDLE hQue;
 * TLR_UINT   uiInstance = 0;
 * 
 * eRslt = TLR_QUE_IDENTIFY_INTERN(
 *                                 PROFIBUSMPI_RFC1006_QUEUE_NAME,
 *                                 uiInstance,
 *                                 &hQue
 *                                );
 * @endcode
 * <br>
 * Example for external or normal identification:<br>
 * @code
 * TLR_RESULT      eRslt;
 * TLR_QUE_LINK_T  tQue;
 * TLR_UINT        uiInstance = 0;
 * 
 * eRslt = TLR_QUE_IDENTIFY(PROFIBUSMPI_RFC1006_QUEUE_NAME, uiInstance, &tQue);
 * @endcode
 * <br>
 * @{
 */
/** queue name */
#define PROFIBUSMPI_RFC1006_QUEUE_NAME        "QUE_RFC1006"
#define PROFIBUSMPI_RFC1006_STORAGEQUEUE_NAME        "QUE_RFCSTORE"

/** @} */


/*************************************************************************************/
/* packets */

/* pragma pack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_PACK_1(__PROFIBUSMPI_RFC1006_PACKET)
#endif

#define PROFIBUSRFC_CMD_CYCLE_EVENT_IND 0x000043F6
#define MAX_NUMBER_OF_RFC_SOCKETS 16

typedef struct PROFIBUSMPI_RFC1006_HEADER_Ttag
{
  TLR_UINT8 ubVersion;
  TLR_UINT8 ubReserved;
  TLR_UINT16 uiLength;
  
  TLR_UINT8   ubLi_4;
  TLR_UINT8   ubCDT       :4;
  TLR_UINT8   ubTPDUCode  :4;
  TLR_UINT16  ubDstRef;  
  TLR_UINT16  ubSrcRef;
  TLR_UINT8   ubOption    :2;
  TLR_UINT8   ubReserved2 :2;
  TLR_UINT8   ubClass     :4;
  TLR_UINT8   abData[32];
}PROFIBUSMPI_RFC1006_HEADER_T;

typedef struct PROFIBUSMPI_RFC1006_DT_Ttag
{
  TLR_UINT8 ubVersion;
  TLR_UINT8 ubReserved;
  TLR_UINT16 uiLength;
  
  TLR_UINT8   ubLi_4;
  TLR_UINT8   ubReserved2  :4;
  TLR_UINT8   ubTPDUCode  :4;
  TLR_UINT8   TPDUNr:7;
  TLR_UINT8   fEOT:1; 
  TLR_UINT8   abData[512];
}PROFIBUSMPI_RFC1006_DT_T;

typedef struct PROFIBUSMPI_RFCERRORFRAME_Ttag{
  
  TLR_UINT8  ubVersion;
  TLR_UINT8  ubReserved2;
  TLR_UINT16 uiLength;
  
  TLR_UINT8   ubLi_4;
  TLR_UINT8   ubReserved:4;
  TLR_UINT8   ubTPDUCode:4;
  TLR_UINT16  uiDstRef;
  TLR_UINT16  uiSrcRef;
  TLR_UINT8   ubReason;
  TLR_UINT8   abData[130];
  
}PROFIBUSMPI_RFCERRORFRAME_T;


/* pragma unpack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_UNPACK_1(__PROFIBUSMPI_RFC1006_PACKET)
#endif


/*************************************************************************************/
#endif /* #ifndef __PROFIBUSMPI_RFC1006_PUBLIC_H */
